<?php
/**
 * Multiple Selections in PHP
 *
 * Create Multiple Cursors
 *
 * - Press and hold Alt and use the mouse to select the locations where a cursor
 *    is desired (Windows/Linux/macOS)
 *
 * Revert to One Cursor
 *
 * - Escape (Windows/Linux/macOS)
 *
 * Select Next Occurrence
 *
 *   - Alt+J (Windows/Linux)
 *   - Ctrl+G (macOS)
 *
 * Put the cursor in multiple locations in a file and write code simultaneously
 *    in all these positions
 */

// 1. Check below. This is all plain text, we would like to add all resources to
//    an array.
//    Delete the first line and the blank line so only the actual resources remain.
// 2. Place the cursor right after the first `*`. Press and hold Alt and use the mouse
//    to select the locations where a cursor is desired, right after every `*`.
// 3. Release Alt and start typing. Text should now appear at every cursor. Use
//    backspace to remove all `*`. Add `'` at the start of each line.
//    Move the cursors to the end of the line and add `',`.
// 4. Press Escape to revert back to one cursor. Select the | in the first line.
//    Use Select Next Occurrence to select all | characters and have a cursor there.
//    Remove the character and replace it with `', '`.
//    Move the cursors to the end of the line and press the delete key. This will
//    move all resources to just one line.
// 5. Press Escape to revert back to one cursor and add `array(` at the beginning of
//    all lines and `);` at the end. We now have an array declaration.
// 6. Hold Shift+Alt and drag the mouse from the number 6 in front to the // 1..
//    Note how the multiple selection now selected a block of text we can work with
//    and added multiple cursors.

PhpStorm Resources

* Blog | http://blog.jetbrains.com/phpstorm
* Twitter | http://twitter.com/phpstorm
* Video tutorials | http://www.jetbrains.com/phpstorm/documentation/phpstorm-video-tutorials.jsp
* Help | https://www.jetbrains.com/help/phpstorm
